<?php

namespace Controllers;

use App\Database;

class ViewsController
{
    private $db;
    
    public function __construct() {
        $this->db = new Database();
    }
    
    /**
     * Display the main index view
     * 
     * @return void
     */
    public function viewIndex(): void
    {
        try {
            // Get active sponsors to display on the home page
            $sponsors = $this->db->getActiveSponsors();
            
            // Get the site configuration
            $config = $GLOBALS['config'] ?? [];
            
            // Extract the config for use in the view
            extract(['site_config' => $config, 'sponsors' => $sponsors]);
            
            // Include the view file
            $viewFile = __DIR__ . '/../public/views/index.view.php';
            
            if (file_exists($viewFile)) {
                // Include the header
                require __DIR__ . '/../public/views/partials/head.php';
                require __DIR__ . '/../public/views/partials/head_image.php';
                
                // Include the main content
                require $viewFile;
                
                // Include the footer
                require __DIR__ . '/../public/views/partials/footer.php';
            } else {
                throw new Exception("View file not found: " . $viewFile);
            }
        } catch (Exception $e) {
            // Log the error
            error_log("Error in ViewsController::viewIndex: " . $e->getMessage());
            
            // Show a user-friendly error message
            header("HTTP/1.1 500 Internal Server Error");
            echo "An error occurred while loading the page. Please try again later.";
        }
    }

    public function about()
    {
        return view('about');
    }

    public function contact()
    {
        return view('contact');
    }

    /**
     * Display the video view
     * 
     * @param string|null $video The video to display
     * @return void
     */
    public function showVideo($video = null): void
    {
        try {
            $viewFile = __DIR__ . '/../public/views/show_video.view.php';
            
            if (file_exists($viewFile)) {
                // Include the header
                require __DIR__ . '/../public/views/partials/head.php';
                
                // Include the main content
                require $viewFile;
                
                // Include the footer
                require __DIR__ . '/../public/views/partials/footer.php';
            } else {
                throw new Exception("View file not found: " . $viewFile);
            }
        } catch (Exception $e) {
            // Log the error
            error_log("Error in ViewsController::showVideo: " . $e->getMessage());
            
            // Show a user-friendly error message
            header("HTTP/1.1 500 Internal Server Error");
            echo "An error occurred while loading the video. Please try again later.";
        }
    }
}