<?php
/* contains the site configuration */

// Parse without sections
$site_config = parse_ini_file(__DIR__ . '/public/config/site.cfg');

// Compute protocol and dynamic base pieces
$https = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
$protocol = $https ? 'https://' : 'http://';
$scriptDir = rtrim(str_replace('\\\\', '/', dirname($_SERVER['SCRIPT_NAME'])), '/');
$base_url = rtrim($protocol . $_SERVER['HTTP_HOST'] . ($scriptDir === '/' ? '' : $scriptDir), '/');

// Normalize basePath to '' or '/Something'
$base_path = $scriptDir === '/' ? '' : $scriptDir;

return [
    // Base path for routing
    'basePath' => $base_path,

    // Base path for routing
    'basePath' => '/HomeHardware_PWA/HomeHardware/htdocs',
    
    'site' => [
        'id' => $site_config['site_ref'] ?? '',
        'siteLocation' => $site_config['site_location'] ?? '',
        'siteContact' => $site_config['site_contact'] ?? '',
        'siteURL' => $site_config['chain_url'] ?? '',
        'baseURL' => $base_url,
    ],
    'pwa' => [
        'name' => 'Home Hardware PWA',
        'short_name' => 'HomeHW',
        'theme_color' => '#0f172a',
        'background_color' => '#ffffff',
        'display' => 'standalone',
        'orientation' => 'portrait',
        'scope' => ($base_path === '' ? '/' : $base_path . '/'),
        'start_url' => ($base_path === '' ? '/' : $base_path . '/'),
        'icons' => [
            [
                'src' => '' . ($base_path === '' ? '' : $base_path . '/') . 'icons/icon-192x192.png',
                'sizes' => '192x192',
                'type' => 'image/png'
            ],
            [
                'src' => '' . ($base_path === '' ? '' : $base_path . '/') . 'icons/icon-512x512.png',
                'sizes' => '512x512',
                'type' => 'image/png'
            ]
        ]
    ]
];
