﻿<?php
// Test database connection and check sponsors
require_once __DIR__ . '/app/Database.php';
require_once __DIR__ . '/app/Config.php';

// Test database connection
try {
    $db = new \App\Database();
    echo "✅ Successfully connected to the database.\n";
    
    // Check sponsors
    $sponsors = $db->getAllSponsors();
    $count = count($sponsors);
    
    echo "\nFound $count sponsors in the database.\n";
    
    if ($count > 0) {
        echo "\nFirst 5 sponsors:\n";
        echo str_repeat("-", 50) . "\n";
        
        foreach (array_slice($sponsors, 0, 5) as $sponsor) {
            echo "ID: {$sponsor['id']}\n";
            echo "Business: {$sponsor['business_name']}\n";
            echo "Active: " . ($sponsor['is_active'] ? 'Yes' : 'No') . "\n";
            echo "Display Order: {$sponsor['display_order']}\n";
            echo str_repeat("-", 50) . "\n";
        }
    } else {
        echo "\nNo sponsors found. The database might be empty.\n";
        echo "You can add sponsors through the admin interface.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    
    // Show more detailed error information
    echo "\nDebug Information:\n";
    echo "- Database Path: " . (defined('App\\Config::PATH_TO_SQLITE_FILE') ? App\Config::PATH_TO_SQLITE_FILE : 'Not defined') . "\n";
    echo "- File Exists: " . (file_exists(__DIR__ . '/' . App\Config::PATH_TO_SQLITE_FILE) ? 'Yes' : 'No') . "\n";
    if (defined('App\\Config::PATH_TO_SQLITE_FILE') && file_exists(__DIR__ . '/' . App\Config::PATH_TO_SQLITE_FILE)) {
        echo "- File Permissions: " . substr(sprintf('%o', fileperms(__DIR__ . '/' . App\Config::PATH_TO_SQLITE_FILE)), -4) . "\n";
    }
}
