<?php
require('public/views/partials/utilities_header.php');
?>
<?php
require('public/views/partials/navbar.php');
?>
<?php
require('public/views/partials/bootstrap_messaging.php');
?>


<div class="container d-flex flex-column align-items-center mt-5">
    <h1>Playlist Utilities</h1>
    <br>
    <h3>Create CSV from Folder Contents</h3>
    <div class="col-6 mx-auto">
        <form class="mb-3 border p-3" name="create_csv" method="post">
            <div class="form-group">
                <label for="folder_path">Path to MP4 Files</label>
                <input type="text" class="form-control" id="folder_path" name="folder_path" value="public/sponsor_assets/mp4s/">
            </div>
            <br>
            <button type="submit" name="submit_filepath" class="btn btn-primary">Submit</button>
        </form>
    </div>
    <h3>Validate CSV File</h3>
    <div class="col-6 mx-auto">
        <form class="mb-3 border p-3" name="validate_csv" method="post">
            <div class="form-group">
                <label for="folder_path">Path to CSV</label>
                <input type="text" class="form-control" id="folder_path" name="folder_path" value="public/sponsor_assets/mp4s/files.csv">
            </div>
            <br>
            <button type="submit" name="submit_csv" class="btn btn-primary">Submit</button>
        </form>
    </div>

    <h3>CSV File Contents</h3>
    <div class="col-6 mx-auto">
        <?php if ($csvExists): ?>
            <?php
            $rows = array_map('str_getcsv', file($csvPath));
            $header = array_shift($rows);
            ?>
        <div class="d-flex justify-content-center">"
            <table class="table table-bordered">
                <thead>
                <tr>
                    <?php foreach ($header as $col): ?>
                        <th><?= htmlspecialchars($col) ?></th>
                    <?php endforeach; ?>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($rows as $row): ?>
                    <tr>
                        <?php foreach ($row as $col): ?>
                            <td><?= htmlspecialchars($col) ?></td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
            <p>No file playlist found</p>
        <?php endif; ?>
    </div>
</div>
<script src="/public/app_assets/js/bootstrap.bundle.min.js"></script>
<?php
require('public/views/partials/closing_tags.php');
?>