<?php
// check for session status - start one if required
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Database Utilities</title>
    <link rel="stylesheet" type="text/css" href="/public/app_assets/css/bootstrap.min.css">
</head>
<body>
<?php
/**
 * @var array $sponsors
 */
require('public/views/partials/navbar.php');
?>


<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger" role="alert">
        <?= is_array($_SESSION['error']) ? implode(', ', $_SESSION['error']) : $_SESSION['error']; ?>
    </div>
<?php unset($error); ?>
<?php endif; ?>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success" role="alert">
        <?= $_SESSION['success']; ?>
    </div>
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<div class="container d-flex flex-column align-items-center mt-5">
    <h1>Database Utilities</h1>
    <br>
    <table class="table">
        <thead>
        <tr>
            <th>ID</th>
            <th>Business Name</th>
            <th colspan="2">Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($sponsors as $sponsor): ?>
            <tr>
                <td><?= $sponsor['id'] ?></td>
                <td><?= $sponsor['business_name'] ?></td>
                <td>
                    <form method="get" action="database_utilities/edit">
                        <input type="hidden" name="id" value="<?= $sponsor['id'] ?>">
                        <button type="submit" class="btn btn-primary">Edit</button>
                    </form>
                </td>
                <td>
                    <form method="post" action="database_utilities/delete" onsubmit="return confirm('Are you sure you want to delete this sponsor?');">
                        <input type="hidden" name="id" value="<?= $sponsor['id'] ?>">
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>


</div>
<script src=/public/app_assets/js/bootstrap.bundle.min.js></script>
</body>
</html>