<nav class="navbar navbar-expand-lg navbar-light bg-dark">
    <div class="container-fluid">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav bg-dark">
                <li class="nav-item">
                    <a class="nav-link text-white" href="utilities">Utilities Home</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="phpinfo">PHPInfo</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="/playlist_utilities">Playlist Utils</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="/configure">Config Utils</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" id="registerMessages" href="/register_messaging">Register for Messages</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" id="registerContent" href="/register_content">Register for Content</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="/database_utilities">Database Utils</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" id="downloadContent" href="#">Download Content</a>
                </li>
            </ul>
            <!-- RH side of navbar -->
            <ul class="navbar-nav ml-auto bg-dark">
                <li class="nav-item">
                    <a class="nav-link text-white" href="index">Return to Index</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<script>
    document.getElementById('registerMessages').addEventListener('click', function(event) {
        if (!confirm('Are you sure you want to register for messages?')) {
            event.preventDefault();
        }
    });

    document.getElementById('registerContent').addEventListener('click', function(event) {
        if (!confirm('Are you sure you want to register for content?')) {
            event.preventDefault();
        }
    });

    document.getElementById('downloadContent').addEventListener('click', function(event) {
        if (confirm('Are you sure you want to download content?')) {
            fetch('/run_downloader_ajax.php')
                .then(response => response.text())
                .then(data => {
                    console.log('Data received:', data); // Debugging line
                    // Store the output in localStorage
                    localStorage.setItem('contentDownloadOutput', data);
                    console.log('Redirecting to content download view'); // Debugging line
                    // Redirect to the content download view
                    window.location.href = '/public/views/utilities/content_download.view.php';
                })
                .catch(error => console.error('Error:', error));
        }
    });

</script>