<?php
// Fix paths in config files
$basePath = '/HomeHardware_PWA/HomeHardware/htdocs';

// 1. Update config.php
$configFile = __DIR__ . '/config.php';
$configContent = file_get_contents($configFile);
$configContent = str_replace(
    [
        "'basePath' => '/[^']*'",
        "'scope' => '/[^']*'",
        "'start_url' => '/[^']*'"
    ],
    [
        "'basePath' => '$basePath'",
        "'scope' => '$basePath/'",
        "'start_url' => '$basePath/'"
    ],
    $configContent
);
file_put_contents($configFile, $configContent);

// 2. Update .htaccess
$htaccessFile = __DIR__ . '/.htaccess';
$htaccessContent = "RewriteEngine On\n";
$htaccessContent .= "RewriteBase $basePath/\n";
$htaccessContent .= "Options -Indexes\n";
$htaccessContent .= "RewriteCond %{REQUEST_FILENAME} !-d\n";
$htaccessContent .= "RewriteCond %{REQUEST_FILENAME} !-f\n";
$htaccessContent .= "RewriteRule ^ index.php [L]\n";
file_put_contents($htaccessFile, $htaccessContent);

// 3. Create a test file to verify the base URL
echo "✅ Paths have been updated successfully!\n";
echo "Base path set to: $basePath\n";
echo "Please clear your browser cache and try accessing:\n";
echo "http://localhost$basePath/admin\n";
?>
