<?php

// Check the structure of the sponsors table
$dbPath = __DIR__ . '/../../db/sponsors.db';

try {
    // Connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if table exists
    $tableExists = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='sponsors'")->fetch();
    
    if (!$tableExists) {
        die("The 'sponsors' table does not exist.\n");
    }
    
    // Get table info
    $columns = $db->query("PRAGMA table_info(sponsors)")->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Sponsors table columns:\n";
    foreach ($columns as $column) {
        echo "- {$column['name']} ({$column['type']})\n";
    }
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}
