<?php

// Ensure the migrations directory exists
$migrationsDir = __DIR__ . '/migrations';
if (!file_exists($migrationsDir)) {
    mkdir($migrationsDir, 0777, true);
}

// Get all migration files
$migrations = [];
if ($handle = opendir($migrationsDir)) {
    while (false !== ($entry = readdir($handle))) {
        if (preg_match('/^\d+_.+\.php$/', $entry)) {
            $migrations[] = $entry;
        }
    }
    closedir($handle);
}

// Sort migrations by name
sort($migrations);

// Run each migration
foreach ($migrations as $migration) {
    echo "Running migration: $migration\n";
    require $migrationsDir . '/' . $migration;
    echo "\n";
}

echo "All migrations completed.\n";
