<?php
// Database connection
$dbPath = __DIR__ . '/sponsor_content.db';
$db = new PDO('sqlite:' . $dbPath);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Get table info
echo "Checking sponsors table structure...\n";
$result = $db->query("PRAGMA table_info('sponsors')");
$columns = $result->fetchAll(PDO::FETCH_ASSOC);

echo "Columns in sponsors table:\n";
foreach ($columns as $column) {
    echo "- {$column['name']} ({$column['type']})\n";
}

// Check if business_name exists
$hasBusinessName = false;
foreach ($columns as $column) {
    if ($column['name'] === 'business_name') {
        $hasBusinessName = true;
        break;
    }
}

if (!$hasBusinessName) {
    echo "\nERROR: The 'business_name' column is missing from the sponsors table.\n";
    echo "Current columns are: " . implode(', ', array_column($columns, 'name')) . "\n";
    
    // Show sample data to help identify the correct column name
    try {
        $sample = $db->query("SELECT * FROM sponsors LIMIT 1")->fetch(PDO::FETCH_ASSOC);
        if ($sample) {
            echo "\nSample data from first sponsor record:\n";
            print_r($sample);
        }
    } catch (Exception $e) {
        echo "\nError fetching sample data: " . $e->getMessage() . "\n";
    }
}

// Check for any other potential issues
$missingColumns = [];
$requiredColumns = ['name', 'email', 'is_active'];
foreach ($requiredColumns as $col) {
    $found = false;
    foreach ($columns as $column) {
        if (strtolower($column['name']) === strtolower($col)) {
            $found = true;
            break;
        }
    }
    if (!$found) {
        $missingColumns[] = $col;
    }
}

if (!empty($missingColumns)) {
    echo "\nWARNING: The following important columns might be missing: " . implode(', ', $missingColumns) . "\n";
}
?>
