<?php
// Database configuration - update these with your actual database credentials
$dbHost = 'localhost';
$dbName = 'your_database_name';  // Change this to your database name
$dbUser = 'root';               // Default XAMPP username
$dbPass = '';                   // Default XAMPP password is empty

try {
    // Connect to MySQL
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Database Connection Successful</h2>";
    
    // Check if sponsors table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'sponsors'");
    if ($stmt->rowCount() > 0) {
        echo "<h3>Sponsors Table Structure:</h3>";
        
        // Get table structure
        $stmt = $pdo->query("DESCRIBE sponsors");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' cellpadding='5' cellspacing='0'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        
        $hasBusinessName = false;
        $columnNames = [];
        
        foreach ($columns as $column) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($column['Field']) . "</td>";
            echo "<td>" . htmlspecialchars($column['Type']) . "</td>";
            echo "<td>" . htmlspecialchars($column['Null']) . "</td>";
            echo "<td>" . htmlspecialchars($column['Key']) . "</td>";
            echo "<td>" . htmlspecialchars($column['Default'] ?? 'NULL') . "</td>";
            echo "<td>" . htmlspecialchars($column['Extra']) . "</td>";
            echo "</tr>";
            
            $columnNames[] = $column['Field'];
            if (strtolower($column['Field']) === 'business_name') {
                $hasBusinessName = true;
            }
        }
        echo "</table>";
        
        // Check for business_name column
        if (!$hasBusinessName) {
            echo "<p style='color: red;'><strong>ERROR:</strong> The 'business_name' column is missing from the sponsors table.</p>";
            echo "<p>Current columns are: " . htmlspecialchars(implode(', ', $columnNames)) . "</p>";
            
            // Try to get sample data
            try {
                $sample = $pdo->query("SELECT * FROM sponsors LIMIT 1")->fetch(PDO::FETCH_ASSOC);
                if ($sample) {
                    echo "<h3>Sample Data:</h3>";
                    echo "<pre>";
                    print_r($sample);
                    echo "</pre>";
                }
            } catch (Exception $e) {
                echo "<p>Error fetching sample data: " . htmlspecialchars($e->getMessage()) . "</p>";
            }
        }
    } else {
        echo "<p style='color: red;'><strong>ERROR:</strong> The 'sponsors' table does not exist in the database.</p>";
    }
    
} catch (PDOException $e) {
    die("<p style='color: red;'><strong>Database Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>");
}
?>
