<?php

namespace Controllers;

use Controllers\Playlist;
use JetBrains\PhpStorm\NoReturn;

class PlaylistUtilitiesController
{
    private \Controllers\Playlist $playlist;

    public function __construct()
    {
        $this->playlist = new Playlist();
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function showUtilities(): void
    {
        // Check if files.csv exists
        $csvPath = 'public/sponsor_assets/mp4s/files.csv';
        $csvExists = file_exists($csvPath);

        // Load the view
        require 'public/views/utilities/playlist_utilities.view.php';
    }

    #[NoReturn] public function handleFormSubmission(): void
    {
        if (isset($_POST['submit_filepath'])) {
            $path = $_POST['folder_path'];
            $result = $this->playlist->createFilesCSV($path);

            if ($result === true) {
                $_SESSION['success'] = 'CSV file created successfully.';
            } else {
                $_SESSION['error'] = $result;
            }
        } elseif (isset($_POST['submit_csv'])) {
            $path = $_POST['folder_path'];
            $errors = $this->playlist->validateCSV($path);

            if ($errors === null) {
                $_SESSION['success'] = 'CSV file validated successfully.';
            } else {
                $_SESSION['error'] = $errors;
            }
        }

        header('Location: /playlist_utilities');
        exit();
    }
}