<?php
// index.php

// Define the base path
$basePath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

// Set the base URL
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
$baseUrl = $protocol . $_SERVER['HTTP_HOST'] . ($basePath === '' ? '' : $basePath);

// Load the configuration
$config = require __DIR__ . '/config.php';

// Set the base URL in the config
$config['baseUrl'] = $baseUrl;

// Start the session
session_start();

// Set the include path
set_include_path(get_include_path() . PATH_SEPARATOR . __DIR__ . '/app');

// Autoload classes
spl_autoload_register(function ($class) {
    $file = __DIR__ . '/app/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require $file;
    }
});

// Handle the request
$request = $_SERVER['REQUEST_URI'];
$basePath = $config['basePath'];

// Remove base path from request
$request = str_replace($basePath, '', $request);

// Remove query string
$request = strtok($request, '?');

// Set error reporting - hide E_STRICT and E_DEPRECATED
// 8192 is the error level for E_DEPRECATED which includes the implicit conversion warnings
error_reporting(E_ALL & ~E_STRICT & ~E_DEPRECATED);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/storage/tmp/php-error.log');

// Load required files
require 'vendor/autoload.php';
require 'path_helper.php';

// Initialize the router
$router = require 'routes.php';

// Match the current request
$match = $router->match();

if ($match) {
    // Check if the target is callable
    if (is_callable($match['target'])) {
        call_user_func_array($match['target'], $match['params']);
    } else {
        // Handle controller@method format
        list($controller, $method) = explode('@', $match['target']);
        
        // Add the Controllers namespace
        $controller = 'Controllers\\' . $controller;
        
        // Check if the controller class exists
        if (class_exists($controller)) {
            $controllerInstance = new $controller();
            
            // Check if the method exists
            if (method_exists($controllerInstance, $method)) {
                call_user_func_array([$controllerInstance, $method], $match['params']);
            } else {
                // Method not found
                header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
                echo '404 - Method not found: ' . $method;
            }
        } else {
            // Controller not found
            header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
            echo '404 - Controller not found: ' . $controller;
        }
    }
} else {
    // No route was matched
    header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
    echo '404 - Page not found: ' . $_SERVER['REQUEST_URI'];
}

// Route the request
switch ($request) {
    case '':
    case '/':
        require __DIR__ . '/public/views/home.php';
        break;
    case '/admin':
    case '/admin/':
        $controller = new \Controllers\AdminController();
        $controller->index();
        break;
    case '/admin/create':
        $controller = new \Controllers\AdminController();
        $controller->create();
        break;
    case (preg_match('/^\/admin\/edit\/(\d+)$/', $request, $matches) ? true : false):
        $controller = new \Controllers\AdminController();
        $controller->edit($matches[1]);
        break;
    case (preg_match('/^\/admin\/delete\/(\d+)$/', $request, $matches) ? true : false):
        $controller = new \Controllers\AdminController();
        $controller->delete($matches[1]);
        break;
    case '/admin/login':
        $controller = new \Controllers\AdminController();
        $controller->login();
        break;
    case '/admin/logout':
        $controller = new \Controllers\AdminController();
        $controller->logout();
        break;
    default:
        http_response_code(404);
        require __DIR__ . '/public/views/404.php';
        break;
}
