<?php

namespace Controllers;

class BrochureController
{
    private string $fileName;

    public function __construct()
    {
        // PDO object is accepted but not stored
        //$this->fileName = $fileName;
        $config = parse_ini_file('public/config/site.cfg');
        $this->fileName = $config['brochures_path'];
    }

    public function getBrochures() : array
    {
        $rows = array_map('str_getcsv', file($this->fileName));
        $header = array_shift($rows);
        $brochures = array();
        foreach($rows as $row) {
            $brochures[] = array_combine($header, $row);
        }
        return $brochures;
    }

    public function sortBrochures(array $brochures) : array
    {
        $key_values = array_column($brochures, 'brochure');
        array_multisort($key_values, SORT_ASC, $brochures);
        return $brochures;
    }

    public function showBrochures(): void
    {
        $brochures = $this->getBrochures();
        $brochures = $this->sortBrochures($brochures);
        require 'public/views/brochures_all.view.php';
    }

    public function showBrochureDetail(): void
    {
        require 'public/views/brochures_single.view.php';
    }
}

// get path to brochures csv file from site.cfg
//$config = parse_ini_file('public/config/site.cfg');
//$brochurePath = $config['brochures_path'];

// create BrochureController object
$brochure = new BrochureController();

// get all brochures if file hasn't been passed in URL
if (isset($_GET['file'])) {
    $brochure->showBrochureDetail();
} else {
    $brochure->showBrochures();
}