<?php
/* contains the site configuration */

// Parse without sections
$site_config = parse_ini_file(__DIR__ . '/public/config/site.cfg');

// Base URL configuration
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
$base_url = $protocol . $_SERVER['HTTP_HOST'] . '/HomeHardware_PWA/HomeHardware/htdocs';

return [
    // Base path for routing
    'basePath' => '/HomeHardware_PWA/HomeHardware/htdocs',
    
    'site' => [
        'id' => $site_config['site_ref'] ?? '',
        'siteLocation' => $site_config['site_location'] ?? '',
        'siteContact' => $site_config['site_contact'] ?? '',
        'siteURL' => $site_config['chain_url'] ?? '',
        'baseURL' => $base_url,
    ],
    'pwa' => [
        'name' => 'Home Hardware PWA',
        'short_name' => 'HomeHW',
        'theme_color' => '#0f172a',
        'background_color' => '#ffffff',
        'display' => 'standalone',
        'orientation' => 'portrait',
        'scope' => '/',
        'start_url' => '/',
        'icons' => [
            [
                'src' => '/icons/icon-192x192.png',
                'sizes' => '192x192',
                'type' => 'image/png'
            ],
            [
                'src' => '/icons/icon-512x512.png',
                'sizes' => '512x512',
                'type' => 'image/png'
            ]
        ]
    ]
];
