<?php

namespace App;

use PDO;

class SQLiteConnection {

    /**
     * return an instance of the PDO object that connects to the SQLite database
     * @return PDO
     */

    private $pdo;

    public function __construct()
    {
        $this->pdo = new PDO("sqlite:" . Config::PATH_TO_SQLITE_FILE);
        $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    }

    public function getPDO() : PDO
    {
        return $this->pdo;
    }
}