<?php
/**
 * @var string $emailType
 * @var integer $sponsorId
 * @var string $returnString
 */
require('partials/head.php');
require('partials/headimage_secondary.php');
?>

    <div class="back_button"><img src="/public/app_assets/images/back_button.png" alt="back button" onclick="history.back()"></div>

    <!--- Page title text --->

    <div class="page_title">Inquiry</div>

    <!--- Email form container --->

    <div class="email_block">

        <form action="email" method="post" class="email_form">

            <div class="emailrequestheading">
                <div class="largebody">Enter your email address below to contact us with your enquiry</div>
            </div>

            <!--- Input areas for POC and optional message --->

            <div class="emailinput">
                <input type = "text" autocomplete="off" style="width: 560px;height: 50px" id="requestPOC" name="requestPOC"  placeholder="Enter Email Address (Required)" value="<?php if(isset($errors['contactError']) OR isset($errors['agreementError'])){echo $_POST['requestPOC'];} ?>" />
            </div>

            <div class="messageinputbox">
                <textarea id="requestMessage" name="requestMessage"  rows="5" cols="75" placeholder="Brief description of your enquiry (Optional)"><?php if(isset($errors['contactError']) OR isset($errors['agreementError'])){echo $_POST['requestMessage'];} ?></textarea>
            </div>

            <!--- Privacy notice --->

            <div class="emailprivacynotice">

                <div class="mediumbody">
                    <p>This system is provided and maintained by Trade Connect.
                        Your contact details are being requested so that your enquiry can be processed.</p>

                    <p>We will securely retain this information and use it solely for analytics purposes
                        to understand how people use our system. A full privacy policy is
                        available to view by clicking <a href="privacy_policy"><span style="color:red;">here</span></a>, or on request by emailing info@
                        tradeconnect.com</p>
                </div>
                <p>
                <table>
                    <tr>

                        <!--- Consent check box --->

                        <td style="width: 400px">
                            <div class="bold1rem"><span style="font-weight: bold;">I have read and agreed to the terms above</span></div>
                        </td>
                        <td>
                            <input type="checkbox" name="agreed">
                        </td>
                    </tr>
                </table>

            </div>

            <!--- Back and Submit form buttons --->

                <div class="button-container">
                    <button class="form_back_button" type="button" onclick="window.location.href='index'">Back</button>
                    <input type="submit" name="submitBtn" value="Submit" id="submitBtn">
                </div>


            <!--- Output area for any validation errors - DO NOT EDIT --->

            <div class="emailerror">
                <?php if(isset($errors['contactError'])){echo $errors['contactError'] . "<br>";} ?><?php if(isset($errors['agreementError'])){echo $errors['agreementError'] . "<br>";} ?>
            </div>

            <!--- hidden form fields with values passed to next page - DO NOT EDIT --->
            <input type="hidden" id="returnString" name="returnString" value="<?= htmlspecialchars($returnString ?? ''); ?>">
            <input type="hidden" id="emailType" name="emailType" value="<?= htmlspecialchars($emailType ?? ''); ?>">
            <input type="hidden" id="sponsorId" name="sponsorId" value="<?= htmlspecialchars($sponsorId ?? ''); ?>">

        </form>


    </div> <!--- End of email form container --->

<?php require('partials/footer.php'); ?>