<?php /** @noinspection PhpStrFunctionsInspection */

// This controller uses the playlist class to create a playlist extending the $this->playlist to create a playlist from a csv file and a folder of mp4s
// and stores the playlist in the session
namespace Controllers;

use Exception;

class IdleController
{
    public Playlist $playlist;

    public function __construct()
    {
        $this->playlist = new Playlist();
    }

    public function createIdlePlaylist($filePath, $folderPath): void
    {
        // Ensure session is started
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        try {
            $this->playlist->createNewsPlaylist($filePath);
        } catch (Exception $e) {
            echo "Error creating news playlist: " . $e->getMessage();
            header('Location: /index');
            exit;
        }
        // Check if $folderPath points to a CSV file
        if (substr($folderPath, -4) === '.csv') {
            // if true create playlist from CSV
            $this->playlist->createFromCSV($folderPath);
        } else {
            // if false create playlist from folder
            $this->playlist->createFromFolder($folderPath);
        }
        /* use this line to create a playlist from a csv file */
        //$this->playlist->createFromCSV($folderPath);
        /* use this line to create a playlist from a folder of mp4s */
        //$this->playlist->createFromFolder($folderPath);
        $_SESSION['playlist'] = $this->playlist->getPlaylistAsArray();
    }


    public function showIdleScreen()
    {
        $idleController = new IdleController();
        $newsPath = 'public/app_assets/playlists/playlist.csv';
        // read ini file to get value of use_files_csv
        $config = parse_ini_file('public/config/site.cfg');
        if ($config['use_files_csv'] == 'true') {
            $mp4sPath = 'public/sponsor_assets/mp4s/files.csv';
        } else {
            $mp4sPath = 'public/sponsor_assets/mp4s/';
        }
        /* use this line for generating a playlist from a csv file */
        // $mp4sPath = 'public/sponsor_assets/mp4s/files.csv';
        /* use this line for generating a playlist from a folder of mp4s */
        //$mp4sPath = 'public/sponsor_assets/mp4s/';
        try {
            $idleController->createIdlePlaylist($newsPath, $mp4sPath);
        } catch (Exception $e) {
            echo "Error creating idle playlist: " . $e->getMessage();
            header('Location: /index');
            exit;
        }

        // if current playlist index is not set, set to 0
        if (!isset($_SESSION['current_playlist_index'])) {
            $_SESSION['current_playlist_index'] = 0;
        } elseif ($_SESSION['current_playlist_index'] > 0) {
            $_SESSION['current_playlist_index'] = 0;
        }

        require 'public/views/show_idle.view.php';
    }



}