<?php

namespace Controllers;

use JetBrains\PhpStorm\NoReturn;
use PDO;

class DatabaseUtilitiesController extends BaseController
{
    public SponsorsController $sponsorController;

    public function __construct(PDO $pdo)
    {
        parent::__construct($pdo); // Call the parent constructor
        $this->sponsorController = new SponsorsController($pdo);
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function index(): void
    {
        $this->sponsorController->checkDatabaseConnection();
        $sponsors = $this->sponsorController->getSponsors();
        require 'public/views/utilities/database_utilities_index.view.php';
    }

    public function edit($id): void
    {
        $id = $this->extractID($id);
        $sponsor = $this->sponsorController->getSponsors($id);
        require 'public/views/utilities/database_utilities_edit.view.php';
    }

    #[NoReturn] public function update(): void
    {
        $result = $this->sponsorController->updateSponsor($_POST);
        if ($result === true) {
            $_SESSION['success'] = "Record updated successfully";
        } else {
            $_SESSION['error'] = $result;
        }
        header("Location: /database_utilities");
        exit();
    }

    #[NoReturn] public function delete(): void
    {
        $result = $this->sponsorController->deleteSponsor($_POST['id']);
        if ($result === true) {
            $_SESSION['success'] = "Record deleted successfully";
        } else {
            $_SESSION['error'] = $result;
        }
        header("Location: /database_utilities");
        exit();
    }
}