<?php
namespace Controllers;

use App\SQLiteConnection;
use Exception;

class ConfirmMailController
{
    private SendMailController $mailer;
    private string $recipientEmail;
    private array $site_config;
    private array $emailValues;

    public function __construct(array $emailValues, EmailController $emailController)
    {
        $this->mailer = new SendMailController($emailController);
        $this->site_config = include('config.php');
        $this->emailValues = $emailValues;
    }

    public function setRecipientEmail(): void
    {
        try {
            switch ($this->emailValues['emailType']) {
                case 'sponsor':
                    $connection = new SQLiteConnection();
                    $sponsorsController = new SponsorsController($connection->getPDO());
                    $sponsorData = $sponsorsController->getSponsors($this->emailValues['sponsorId']);
                    $this->recipientEmail = $sponsorData['email'];
                    $this->emailValues['sponsorName'] = $sponsorData['business_name'];
                    $this->emailValues['returnString'] = "/select_sponsor?id={$this->emailValues['sponsorId']}";
                    break;
                case 'store':
                    $this->recipientEmail = $this->site_config['site']['siteContact'];
                    $this->emailValues['returnString'] = 'index';
                    break;
                default:
                    throw new Exception('Invalid recipient email type');
            }
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }

    public function createMailFieldValues(): array
    {
        $this->setRecipientEmail();

        return [
            'recipientEmail' => $this->recipientEmail,
            'sendingLocation' => $this->site_config['site']['siteLocation'],
            'emailType' => $this->emailValues['emailType'],
            'requestPOC' => $this->emailValues['requestPOC'],
            'requestMessage' => $this->emailValues['requestMessage'],
            'returnString' => $this->emailValues['returnString'],
            'sponsorName' => $this->emailValues['sponsorName'] ?? 'N/A'
        ];
    }

    public function startProcessing(): void
    {
        $mailFieldValues = $this->createMailFieldValues();
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        $_SESSION['mailFieldValues'] = $mailFieldValues;
        require 'public/views/confirm_mail.view.php';
    }

    public function sendConfirmedEmail(): void
    {
        try {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            $mailFieldValues = $_SESSION['mailFieldValues'];
            $this->mailer->sendEmail($mailFieldValues);
        } catch (Exception $e) {
            echo 'Caught exception: ', $e->getMessage(), "\n";
        }
    }
}