# Home Hardware PWA - Admin Panel

This is the admin panel for managing sponsors in the Home Hardware PWA application. It allows you to add, edit, and remove sponsors, as well as manage their associated images and videos.

## Features

- **Sponsor Management**: Add, edit, and delete sponsors
- **Media Uploads**: Upload sponsor logos and videos
- **Responsive Design**: Works on desktop and mobile devices
- **Secure Authentication**: Protected admin area with login
- **Drag & Drop**: Easy file uploads with preview

## Requirements

- PHP 7.4 or higher
- SQLite3 extension for PHP
- Fileinfo extension for PHP
- mod_rewrite enabled (for Apache)
- Write permissions for the `uploads/` and `db/` directories

## Installation

1. **Clone the repository** to your web server
   ```
   git clone [repository-url]
   ```

2. **Set up permissions**
   Ensure the web server has write access to these directories:
   ```
   chmod -R 755 db/
   chmod -R 755 public/uploads/
   ```

3. **Configure the database**
   The application will automatically create the database and tables on first run.

4. **Set up authentication**
   Update the admin credentials in `controllers/AdminController.php`:
   ```php
   // In the login() method, update these values
   $username = 'admin';
   $password = 'your_secure_password';
   ```
   
   **Important:** Change the default password before deploying to production!

## Accessing the Admin Panel

1. Open your web browser and navigate to:
   ```
   http://your-domain.com/admin
   ```

2. Log in using the admin credentials you configured.

## Managing Sponsors

### Adding a New Sponsor
1. Click on "Add New Sponsor" in the sidebar
2. Fill in the sponsor details:
   - **Name**: The sponsor's name (required)
   - **Display Order**: The order in which sponsors appear (lower numbers first)
   - **Active**: Check to make the sponsor visible on the frontend
   - **Logo/Image**: Upload a logo (recommended size: 200x200px, PNG with transparent background)
   - **Video**: Optionally upload a video (MP4, WebM, or OGG format)
3. Click "Create Sponsor"

### Editing a Sponsor
1. Click the edit (pencil) icon next to the sponsor you want to edit
2. Update the sponsor details as needed
3. Upload new files to replace the existing ones (optional)
4. Click "Update Sponsor"

### Deleting a Sponsor
1. Click the trash can icon next to the sponsor you want to delete
2. Confirm the deletion in the popup dialog

## File Storage

- Uploaded images are stored in: `public/uploads/images/`
- Uploaded videos are stored in: `public/uploads/videos/`
- The database file is stored in: `db/sponsor_content.db`

## Security

- The admin panel is protected by HTTP authentication
- File uploads are restricted to specific file types
- Sensitive files (like .db, .env, etc.) are blocked from direct access
- Session security settings are enabled

## Troubleshooting

### I can't log in
- Verify the username and password in `AdminController.php`
- Check PHP error logs for any authentication issues
- Ensure sessions are working correctly

### File uploads aren't working
- Check that the `uploads/` directory is writable
- Verify the PHP upload limits in `php.ini`:
  ```
  upload_max_filesize = 20M
  post_max_size = 22M
  ```
- Check the PHP error log for any upload-related errors

### The page shows a 404 error
- Ensure mod_rewrite is enabled on your server
- Verify that the `.htaccess` file is in place and being read
- Check that your web server is configured to allow overrides

## Support

For additional support, please contact your system administrator or the development team.
