<?php

namespace Controllers;

use App\Database;
use App\Config;

class AdminController {
    private $db;
    private $uploadDir;
    private $config;
    
    public function __construct() {
        session_start();
        $this->db = new Database();
        
        // Debug: Show current directory structure
        $configPath = dirname(__DIR__, 2) . '/htdocs/config.php';
        
        if (!file_exists($configPath)) {
            die("Config file not found at: " . $configPath . "<br>Current directory: " . __DIR__);
        }
        $this->config = require $configPath;
        
        // Set up upload directory
        $this->uploadDir = dirname(__DIR__) . '/public/uploads/';
        
        // Create uploads directory if it doesn't exist
        if (!file_exists($this->uploadDir)) {
            mkdir($this->uploadDir, 0755, true);
        }
    }
    
    private function isAuthenticated() {
        return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
    }
    
    private function redirect($path) {
        $basePath = $this->config['basePath'];
        header("Location: {$basePath}{$path}");
        exit();
    }
    
    private function requireAuth() {
        if (!$this->isAuthenticated()) {
            $this->redirect('/admin/login');
        }
    }
    
    public function login() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            
            // Replace with your actual admin credentials
            if ($username === 'admin' && $password === 'T1m3M3d1a!') {
                $_SESSION['admin_logged_in'] = true;
                $this->redirect('/admin');
            } else {
                $error = 'Invalid credentials';
                require __DIR__ . '/../public/views/admin/login.php';
            }
        } else {
            require __DIR__ . '/../public/views/admin/login.php';
        }
    }
    
    public function logout() {
        session_destroy();
        $this->redirect('/admin/login');
    }
    
    public function index() {
        $this->requireAuth();
        $sponsors = $this->db->getAllSponsors();
        require __DIR__ . '/../public/views/admin/index.php';
    }
    
    public function create() {
        $this->requireAuth();
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'name' => $_POST['name'],
                'display_order' => (int)$_POST['display_order'],
                'is_active' => isset($_POST['is_active']) ? 1 : 0
            ];
            
            // Handle file uploads
            if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
                $imagePath = $this->handleFileUpload($_FILES['image'], 'image');
                if ($imagePath) {
                    $data['image_path'] = $imagePath;
                }
            }
            
            if (isset($_FILES['video']) && $_FILES['video']['error'] === UPLOAD_ERR_OK) {
                $videoPath = $this->handleFileUpload($_FILES['video'], 'video');
                if ($videoPath) {
                    $data['video_path'] = $videoPath;
                }
            }
            
            if ($this->db->addSponsor($data)) {
                $this->redirect('/admin?success=1');
            } else {
                $error = 'Failed to add sponsor';
            }
        }
        
        require __DIR__ . '/../public/views/admin/edit.php';
    }
    
    public function createSponsor() {
        $this->requireAuth();
        
        $error = '';
        $success = '';
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'business_name' => $_POST['business_name'] ?? '',
                'contract' => $_POST['contract'] ?? '',
                'address_1' => $_POST['address_1'] ?? '',
                'address_2' => $_POST['address_2'] ?? '',
                'street' => $_POST['street'] ?? '',
                'city' => $_POST['city'] ?? '',
                'county' => $_POST['county'] ?? '',
                'postal_code' => $_POST['postal_code'] ?? '',
                'country' => $_POST['country'] ?? '',
                'phone' => $_POST['phone'] ?? '',
                'mobile' => $_POST['mobile'] ?? '',
                'email' => $_POST['email'] ?? '',
                'url' => $_POST['url'] ?? '',
                'social' => $_POST['social'] ?? '',
                'sort_order' => (int)($_POST['sort_order'] ?? 0),
                'is_active' => isset($_POST['is_active']) ? 1 : 0,
                'display_order' => (int)($_POST['display_order'] ?? 0)
            ];
            
            // Handle file uploads
            if (!empty($_FILES['button']['name'])) {
                $buttonPath = $this->handleFileUpload($_FILES['button'], 'image');
                if ($buttonPath) {
                    $data['button'] = $buttonPath;
                }
            }
            
            if (!empty($_FILES['mp4']['name'])) {
                $videoPath = $this->handleFileUpload($_FILES['mp4'], 'video');
                if ($videoPath) {
                    $data['mp4'] = $videoPath;
                }
            }
            
            if ($this->db->createSponsor($data)) {
                $this->redirect('/admin/sponsors?created=1');
            } else {
                $error = 'Failed to create sponsor';
            }
        }
        
        require __DIR__ . '/../public/views/admin/create.php';
    }
    
    public function edit($id) {
        $this->requireAuth();
        $sponsor = $this->db->getSponsor($id);
        
        if (!$sponsor) {
            header('HTTP/1.0 404 Not Found');
            echo 'Sponsor not found';
            exit();
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'name' => $_POST['name'],
                'display_order' => (int)$_POST['display_order'],
                'is_active' => isset($_POST['is_active']) ? 1 : 0
            ];
            
            // Handle file uploads
            if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
                $imagePath = $this->handleFileUpload($_FILES['image'], 'image');
                if ($imagePath) {
                    // Delete old image if exists
                    if (!empty($sponsor['image_path']) && file_exists(__DIR__ . '/..' . $sponsor['image_path'])) {
                        unlink(__DIR__ . '/..' . $sponsor['image_path']);
                    }
                    $data['image_path'] = $imagePath;
                }
            }
            
            if (isset($_FILES['video']) && $_FILES['video']['error'] === UPLOAD_ERR_OK) {
                $videoPath = $this->handleFileUpload($_FILES['video'], 'video');
                if ($videoPath) {
                    // Delete old video if exists
                    if (!empty($sponsor['video_path']) && file_exists(__DIR__ . '/..' . $sponsor['video_path'])) {
                        unlink(__DIR__ . '/..' . $sponsor['video_path']);
                    }
                    $data['video_path'] = $videoPath;
                }
            }
            
            if ($this->db->updateSponsor($id, $data)) {
                $this->redirect('/admin?success=1');
            } else {
                $error = 'Failed to update sponsor';
            }
        }
        
        require __DIR__ . '/../public/views/admin/edit.php';
    }
    
    public function delete($id) {
        $this->requireAuth();
        $sponsor = $this->db->getSponsor($id);
        
        if ($sponsor) {
            // Delete associated files
            if (!empty($sponsor['image_path']) && file_exists(__DIR__ . '/..' . $sponsor['image_path'])) {
                unlink(__DIR__ . '/..' . $sponsor['image_path']);
            }
            if (!empty($sponsor['video_path']) && file_exists(__DIR__ . '/..' . $sponsor['video_path'])) {
                unlink(__DIR__ . '/..' . $sponsor['video_path']);
            }
            
            $this->db->deleteSponsor($id);
        }
        
        $this->redirect('/admin?deleted=1');
    }
    
    private function handleFileUpload($file, $type) {
        $allowedTypes = [
            'image' => ['jpg', 'jpeg', 'png', 'gif', 'svg'],
            'video' => ['mp4', 'webm', 'ogg']
        ];
        
        $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        
        if (!in_array($fileExt, $allowedTypes[$type] ?? [])) {
            return false;
        }
        
        // Create type-specific directory if it doesn't exist
        $typeDir = $this->uploadDir . $type . 's/';
        if (!file_exists($typeDir)) {
            mkdir($typeDir, 0755, true);
        }
        
        $fileName = uniqid() . '.' . $fileExt;
        $filePath = '/uploads/' . $type . 's/' . $fileName;
        $fullPath = $typeDir . $fileName;
        
        if (move_uploaded_file($file['tmp_name'], $fullPath)) {
            return $filePath;
        }
        
        return false;
    }
}
