<?php

/** @var Router $router */
// index routes
use App\Router;

$router->view('', 'index');
$router->view('index', 'index');


/* Email routes */
// get email form
$router->get('email', 'controllers/EmailController.php');
//post email form
$router->post('email', 'controllers/EmailController.php');
// pass confirmed mail to mailer via confirm mail controller
$router->post('sendmail', 'controllers/sendmail.php');
// show privacy policy
$router->view('privacy_policy', 'privacy_policy');
// show mail result page
$router->view('mailresult', 'mailresult');

/* Sponsors routes */

// show all sponsors or single sponsor depending on whether an id is passed in or not
$router->get('sponsors', 'controllers/handle_sponsors.php');
// show single sponsor qr and details
$router->view('sponsor_qr', 'show_single_sponsor_qr');
// show video (including offers and sponsor videos)
$router->view('showvideo', 'show_video');
// create qr codes for sponsors
$router->get('createqrs', 'controllers/QRController.php');

/* News routes */
$router->get('news', 'controllers/NewsController.php');

/* Brochure routes */
$router->get('brochures', 'controllers/BrochureController.php');

/* idle screen routes */
$router->get('idle', 'controllers/IdleController.php');

// content download routes
$router->get('download-content', 'controllers/ContentDownloaderController.php');


/* Utility routes */
// show home screen for utilities
$router->view('utilities', 'utilities/home_utilities');
// display php info
//$router->get('phpinfo', 'controllers/phpinfo.php');
$router->view('phpinfo', 'utilities/phpinfo');
// playlist utilities
$router->get('playlist_utilities', 'controllers/PlaylistUtilitiesController.php');
$router->post('playlist_utilities', 'controllers/PlaylistUtilitiesController.php');
// config utilities
$router->get('configure', 'controllers/ConfigureAppController.php');
$router->post('configure', 'controllers/ConfigureAppController.php');
// database utilities
$router->get('sponsor_utilities', 'controllers/DatabaseUtilitiesController.php');
$router->post('sponsor_utilities/update', 'controllers/DatabaseUtilitiesController.php');
$router->post('sponsor_utilities/delete', 'controllers/DatabaseUtilitiesController.php');
// site registration utilities
$router->get('site_registration', 'controllers/RegisterSiteController.php');



