<?php
require('public/views/partials/utilities_header.php');
?>
<?php
require('public/views/partials/navbar.php');
?>
<?php
require('public/views/partials/bootstrap_messaging.php');
?>

<div class="row mt-5 mx-5">
        <div class="col-md-4 mb-4">
            <a href="/phpinfo">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_phpinfo_display.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">PHP Info</h5>
                        <p class="card-text text-center">View PHP Info for this device.</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-4 mb-4">
            <a href="/playlist_utilities">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_playlist_utilities.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Playlist Utilities</h5>
                        <p class="card-text text-center">View, generate & validate playlist CSV file.</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-4 mb-4">
            <a href="/configure">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_config_utilities.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Edit System Config</h5>
                        <p class="card-text text-center">View & edit configuration for this unit</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="row mx-5">
        <div class="col-md-4 mb-4">
            <a href="/register_messaging" id="registerMessagesButton">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_register_for_messages.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Register for Messages</h5>
                        <p class="card-text text-center">Register this unit with messaging server</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-4 mb-4">
            <a href="/register_content" id="registerContentButton">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_register_for_content.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Register for Content</h5>
                        <p class="card-text text-center">Register this unit with content server</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-4 mb-4">
            <a href="/database_utilities">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_database_utilities.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Manage Database</h5>
                        <p class="card-text text-center">View, edit & delete sponsor records</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="row mx-5 justify-content-center">
        <div class="col-md-4 mb-4">
            <a href="#" id="downloadContentButton"  >
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_download_content.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Download</h5>
                        <p class="card-text text-center">Force download of content</p>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-4 mb-4">
            <a href="/index">
                <div class="card shadow p-3 mb-5 bg-body rounded d-flex flex-column h-100">
                    <div class="card-body d-flex flex-column align-items-center flex-grow-1">
                        <img src="/public/app_assets/svg/util_return_to_index.svg" alt="phpinfo" class="card_icon mb-3">
                        <h5 class="card-title text-center">Return to Index</h5>
                        <p class="card-text text-center">Quit utilities and return to the index page</p>
                    </div>
                </div>
            </a>
        </div>

</div>



<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('registerMessagesButton').addEventListener('click', function(event) {
            if (!confirm('Are you sure you want to register for messages?')) {
                event.preventDefault();
            }
        });

        document.getElementById('registerContentButton').addEventListener('click', function(event) {
            if (!confirm('Are you sure you want to register for content?')) {
                event.preventDefault();
            }
        });

        document.getElementById('downloadContentButton').addEventListener('click', function(event) {
            if (confirm('Are you sure you want to download content?')) {
                fetch('/run_downloader_ajax.php')
                    .then(response => response.text())
                    .then(data => {
                        console.log('Data received:', data); // Debugging line
                        // Store the output in localStorage
                        localStorage.setItem('contentDownloadOutput', data);
                        console.log('Redirecting to content download view'); // Debugging line
                        // Redirect to the content download view
                        window.location.href = '/public/views/utilities/content_download.view.php';
                    })
                    .catch(error => console.error('Error:', error));
            }
        });
    });
</script>

<script src=/public/app_assets/js/bootstrap.bundle.min.js></script>
<?php
require('public/views/partials/closing_tags.php');
?>

