<?php
/**
 * @var array $sponsor
 * @var string $sponsorAddressDisplay
 */
require('partials/head.php');
require('partials/headimage_secondary.php');
// create query string for qr vcard display
$queryString = 'id=' . $sponsor['id'];
$queryString .= '&contract=' . $sponsor['contract'];
$queryString .= '&button=' . $sponsor['button'];
if(!is_null($sponsorAddressDisplay)) {
    $queryString .= '&address=' . $sponsorAddressDisplay;
}
if(!is_null($sponsor['phone'])) {
    $queryString .= '&phone=' . $sponsor['phone'];
}
if(!is_null($sponsor['social'])) {
    $queryString .= '&social=' . $sponsor['social'];
}
if(!is_null($sponsor['url'])) {
    $queryString .= '&url=' . $sponsor['url'];
}
?>

<!-- using onclick to go back to previous page -->
<a href="/sponsors"><img class="back_button" src="/public/app_assets/images/back_button.png" alt="Back Button"></a>


<div class="single_sponsor_logo">
    <img class="single_sponsor_logo_image" src="public/sponsor_assets/buttons/<?= $sponsor['button']; ?>" alt="" />
</div>


    <a href="/sponsor_qr?id=<?= $sponsor['id']; ?>">
        <div class="menu_button four_button_positioning menu_button_sponsors">
            <div class="menu_text element_light">VIRTUAL BUSINESS CARD</div>
            <div class="menu_arrow"><img src="/public/app_assets/images/arrow_light.png" alt="arrow image"></div>
        </div>
    </a>
    <a href="/email?emailType=sponsor&sponsorId=<?= $sponsor['id']; ?>">
        <div class="menu_button four_button_positioning menu_button_sponsors">
            <div class="menu_text element_light">INQUIRY</div>
            <div class="menu_arrow"><img src="/public/app_assets/images/arrow_light.png" alt="arrow image"></div>
        </div>
    </a>
    <a href="/showvideo?video=<?= $sponsor['mp4']; ?>">
        <div class="menu_button four_button_positioning menu_button_sponsors">
            <div class="menu_text element_light">VIEW ADVERT</div>
            <div class="menu_arrow"><img src="/public/app_assets/images/arrow_light.png" alt="arrow image"></div>
        </div>
    </a>
    <?php if($sponsor['url'] != NULL) : ?>
    <a href="<?= $sponsor['url']; ?>">
        <div class="menu_button four_button_positioning menu_button_sponsors">
            <div class="menu_text element_light">WEBSITE/ORDER</div>
            <div class="menu_arrow"><img src="/public/app_assets/images/arrow_light.png" alt="arrow image"></div>
        </div>
    </a>
    <?php endif; ?>


<?php require('partials/footer.php'); ?>
