<?php
/**
 * @var array $sponsors
 * @var int $sponsorsTotal
 * @var int $nextOffset
 */
require('partials/head.php');
require('partials/headimage_secondary.php');
?>

<a href="index">
    <img class="back_button" src="/public/app_assets/images/back_button.png" onclick="history.back()" alt="Back Button">
</a>
<!--- Page title text --->

    <div class="sponsor_title_block">
        <div class="sponsor_title_text">SCREEN SPONSORS</div>
        <div class="sponsor_subhead"><p>Touch any of the cards to view website, make an enquiry and more.</p>
        </div>
    </div>

<!--- Grid wrapper --->

<div class="button_grid">

<!--- DO NOT EDIT PHP OR HTML CODE BELOW--->

<?php foreach ($sponsors as $sponsor) : ?>

        <a href="/select_sponsor?id=<?php echo $sponsor['id'] ?>">
            <div class ="roundedbox element_light_background">
                <div class="all_sponsors_logo"><img class="all_sponsors_logo_image" src="public/sponsor_assets/buttons/<?= $sponsor['button']; ?>" alt="" /></div>
                <div class="all_sponsors_legend element_dark"><?php echo $sponsor['business_name'] ?></div>
            </div>
        </a>


<?php endforeach; ?>

<?php if ($sponsorsTotal > $nextOffset): ?>
        <a href="sponsors?limit=<?= $this->limit; ?>&offset=<?= $nextOffset; ?>">
            <div class ="roundedbox element_dark_background">
                <div class="all_sponsors_legend element_light">VIEW MORE</div>
            </div>
        </a>
<?php endif; ?>

<!--- End Of PHP/HTML Section --->

    </div> <!--- End of grid wrapper --->

<?php require('partials/footer.php'); ?>