<?php

// Add display_order column to sponsors table
$dbPath = __DIR__ . '/../../db/sponsors.db';

try {
    // Connect to the database
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if column exists
    $columnExists = $db->query("PRAGMA table_info(sponsors)")->fetchAll(PDO::FETCH_COLUMN, 1);
    
    if (!in_array('display_order', $columnExists)) {
        // Add the column
        $db->exec("ALTER TABLE sponsors ADD COLUMN display_order INTEGER DEFAULT 0");
        echo "Successfully added display_order column to sponsors table.\n";
    } else {
        echo "display_order column already exists in sponsors table.\n";
    }
    
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage() . "\n");
}
