<?php

$dbPath = __DIR__ . '/../sponsor_content.db';

try {
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Checking sponsor_content.db\n";
    echo "=================================\n\n";
    
    // Check if sponsors table exists
    $tableExists = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='sponsors'")->fetchColumn();
    
    if (!$tableExists) {
        die("Sponsors table does not exist!\n");
    }
    
    // Get table info
    $tableInfo = $db->query("PRAGMA table_info(sponsors)")->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Table: sponsors\n";
    echo str_repeat('-', 50) . "\n";
    echo "Columns:\n";
    
    foreach ($tableInfo as $column) {
        $default = $column['dflt_value'] ? "DEFAULT {$column['dflt_value']}" : '';
        echo "- {$column['name']} ({$column['type']}) $default\n";
    }
    
    // Get row count
    $count = $db->query('SELECT COUNT(*) FROM sponsors')->fetchColumn();
    echo "\nNumber of rows: $count\n";
    
    // Show sample data
    if ($count > 0) {
        $sampleSize = min(5, $count);
        $stmt = $db->query('SELECT * FROM sponsors LIMIT ' . $sampleSize);
        $sampleData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "\nSample data (first $sampleSize rows):\n";
        foreach ($sampleData as $row) {
            print_r($row);
        }
    }
    
} catch (PDOException $e) {
    die("Error: " . $e->getMessage() . "\n");
}
