<?php

namespace Controllers;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

require '../vendor/autoload.php';

class MessageDownloader
{
    private string $siteLoginID;
    private string $sitePassword;
    private string $siteGroupID;
    protected string $siteID;
    private string $siteLocation;
    private Client $client;

    public function __construct($config)
    {
        $this->siteLoginID = $config['login_id'];
        $this->sitePassword = $config['login_password'];
        $this->siteGroupID = $config['company_id'];
        $this->siteID = $config['site_ref'];
        $this->siteLocation = $config['site_location'];
        $this->client = new Client();
    }

    public function run(): void
    {
        $token = $this->login();
        $slides = $this->getSlides($token);
        $this->writeToFile($slides);
    }

    function hideGoogleNavigation ($linkString): array|string
    {
        preg_match_all('/"/', $linkString,$matches, PREG_OFFSET_CAPTURE);
        return substr_replace($linkString, "&amp;rm=minimal", $matches[0][1][1], 0);
    }

    private function login()
    {
        try {
            $response = $this->client->post("https://time-messaging.com/api/login", [
                'form_params' => [
                    'email' => $this->siteLoginID,
                    'password' => $this->sitePassword
                ]
            ]);
        } catch (GuzzleException $e) {
            echo 'Login unsuccessful';
            exit;
        }

        $data = json_decode($response->getBody(), true);

        if (!isset($data['token'])) {
            echo 'Login unsuccessful';
            exit;
        }

        return [
            "Accept" => "application/json",
            "Authorization" => "Bearer " . $data['token']
        ];
    }

    private function getSlides($headers)
    {
        try {
            $response = $this->client->get("https://time-messaging.com/api/slides/company/$this->siteGroupID", [
                'headers' => $headers
            ]);
        } catch (GuzzleException $e) {

        }

        return json_decode($response->getBody(), true);
    }

    private function writeToFile($slides): void
    {
        $slideHeaders = '"id","user_id","company_id","description","link","time_on","time_off","date_on","date_off","global", "duration", "specific_sites", "display_on_idle", "notes","created_at","updated_at"' . PHP_EOL;
        $fileName = '../public/app_assets/playlists/playlist.csv';
        $fp = fopen($fileName, 'w');

        if (fwrite($fp, $slideHeaders) === FALSE) {
            echo "Cannot write to file ($fileName)";
            exit;
        } else {
            foreach ($slides as $slide) {
                if (strpos($slide['link'], 'iframe')) {
                    $slide['link'] = $this->hideGoogleNavigation($slide['link']);
                }
                fputcsv($fp, $slide);
            }
        }
        fclose($fp);
    }
}

// Usage:
$config = parse_ini_file('..\public\config\site.cfg');
$downloader = new MessageDownloader($config);
$downloader->run();