<?php

namespace Controllers;

use JetBrains\PhpStorm\NoReturn;
use PDO;
use Utilities\ConfigSettings;

class ConfigureAppController
{
    private PDO $pdo;
    private ConfigSettings $configSettings;

    public function __construct(PDO $pdo, ConfigSettings $configSettings = null)
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        $this->pdo = $pdo;
        $this->configSettings = $configSettings ?? new ConfigSettings('public/config/site.cfg');
    }

    public function handleRequest(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->updateConfig($_POST);
        } else {
            $this->showConfig();
        }
    }

    public function showConfig(): void
    {
        $settings = $this->configSettings->getSettings();
        $successMessage = $_SESSION['success'] ?? null;
        unset($_SESSION['success']);
        require 'public/views/utilities/config_utilities.view.php';
    }

    #[NoReturn] public function updateConfig($newSettings): void
    {
        if ($this->configSettings->updateSettings($newSettings)) {
            $_SESSION['success'] = 'Settings updated successfully';
        } else {
            $_SESSION['error'] = 'Failed to update settings';
        }

        header('Location: /configure');
        exit();
    }
}